' ============================================================================
' DutchTV.vbs v1.31 - fix								-NeM - fix by LvdR
' ============================================================================

' Retrieves TV listings from http://www.tvgids.nl/nustraks.php (Dutch TV
' listings)

' Made by request from the Samurize forums:
' http://www.samurize.com/forum/viewtopic.php?id=1426

' ======
' USAGE:
' ======

' 1) Copy DutchTV.vbs to your Samurize/scripts folder

' 2) Add an ActiveScript meter to your Samurize config with this script
'    selected and 'generateListing' selected as the Function.

' 3) Use TextFile meters to view the TV Listings. Each TV channel has 3 
'    lines of information and is listed in the following order:

'      Nederland 1	(lines 1-3)
'      Nederland 2	(lines 4-6)
'      Nederland 3	(lines 7-9)
'      RTL 4		(lines 10-12)
'      RTL 5		(lines 13-15)
'      SBS 6		(lines 16-18)
'      Net 5		(lines 19-21)
'      Nickelodeon	(lines 22-24)
'      Yorin		(lines 25-27)
'      Veronica		(lines 28-30)
'      VRT TV1		(lines 31-33)
'      KETNET/Canvas	(lines 34-36)
'      VTM		(lines 37-39)
'      Kanaal 2		(lines 40-42)
'      VT4		(lines 43-45)

'    So, for example, to see the listings for V8, Add a TextFile meter, point
'    it to the DutchTV.txt file, set the Read Line field to 43 and the Number
'    of Lines field to 3.

' =============
' V1.31 - fix CHANGES:
' =============

' - very simple fix to surpress the switch between Nickelodeon and Yorin


' =============
' V1.31 CHANGES:
' =============

' - fix for empty/weird strings
' - hyperlinks the tv program to the corresponding detail page at tvgids.nl



' =============
' V1.2 CHANGES:
' =============

' - fixed night listings bug
' - fixed bug with shows that had a range (xx:xx-yy:yy) for their listing time
' - support for more channels

' =============
' V1.1 CHANGES:
' =============

' - fixed bug where no listing is given for a particular channel

' ============================================================================
' USER SETTINGS
' ============================================================================

SHOW_STARTTIMES = True		' set to False if you don't want the start
					' times displayed

' ============================================================================

FILE_NAME = "DutchTV.txt"
NUM_CHANNELS = 45

Function generateListing()

	Dim fs,f,htmlResult,textToWrite

	htmlResult = ReturnHTML("http://www.tvgids.nl/nustraks.php?alle=TRUE")
	
	If InStr(htmlResult, "<title>TV Gids Online</title>") = 0 Then
		textToWrite = "Site format has changed." & vbCrlf & "Script has failed."
	Else 
	
		'hardcoded fix for Yorin/Nickelodeon
		For i=1 To NUM_CHANNELS
			fix_yn = 0 'fix for Yorin/Nickelodeon
			if ( (i=8) AND (instr(lcase(getListing(i, htmlResult)),"yorin")) ) then 
				fix_yn = 1
			elseif ( (i=9) AND (instr(lcase(getListing(i, htmlResult)),"nickelodeon")) ) then 
				fix_yn = -1
			end if
			textToWrite = textToWrite & getListing(i+fix_yn, htmlResult) & vbCrlf
		Next
		
	End If
	

	set fs=CreateObject("Scripting.FileSystemObject")
	set f=fs.CreateTextFile(FILE_NAME,true)
	f.write(textToWrite)
	f.close
	set f=nothing
	set fs=nothing

End Function




Private Function getListing(Channel,htmlResult)

	' first cut everything before <table width="100%">
	strAllInfo = Mid(htmlResult, InStr(htmlResult, "<table width=""100%"">"))

	For i=1 to Channel

		' skip to correct channel
		strAllInfo = Mid(strAllInfo, InStr(strAllInfo, "alleprogramm")+4, Len(strAllInfo))
		
	Next

	' cut everything after the end of the listings for this channel
	endChannelPos = InStr(strAllInfo, "</tr>")
	strAllInfo = Mid(strAllInfo, 1, endChannelPos)
	url = Left(strAllInfo,InStr(strAllInfo, """")-1)
'	saveMessage(url)

	' get the channel name
	startPos = InStr(strAllInfo, ">") + 1
	endPos = InStr(strAllInfo, "<")

	channelName = Mid(strAllInfo, startPos, (endPos-startPos)) &  "%lhttp://www.tvgids.nl/alle" & url
	
	strAllInfo = Mid(strAllInfo, endPos+5)
	
	' get start time of what's on now
	startPos = InStr(strAllInfo, "<strong>") + 8
	endPos = InStr(strAllInfo, "</strong>")
	startTime = Mid(strAllInfo, startPos, (endPos-startPos))

	if Len(startTime) <=1 Then

		' no listing

		strAllInfo = Mid(strAllInfo, InStr(strAllInfo, "32%"))

		startPos = InStr(strAllInfo, ">") + 5
		endPos = InStr(startPos, strAllInfo, "</td>") - 3
		
	else
		' listing

		strAllInfo = Mid(strAllInfo, endPos+5)

	
		' get what's on now
		'startPos = InStr(strAllInfo, "programma"">") + 11
		startPos = InStr(strAllInfo, "valign=""top"">") + 13


		endPos = InStr(startPos, strAllInfo, "</td>")
	end if
	
	
	If SHOW_STARTTIMES = True Then
		if InStr(startTime, ":")<1 Then
			nowShowing = ""
		Else
			nowShowing = "(" & TrimHTML(startTime) & ") "
		End if
	End If
	' next line added to support hyperlinks
	strLinkprogramma = Mid(strAllInfo, InStr(strAllInfo, "pid=")+4, 7)

	' clean up the string
	temp = Mid(strAllInfo, startPos, (endPos-startPos))
	' next If-statement added to support hyperlinks
	If IsNumeric(strLinkprogramma) Then
	temp = temp & "%lhttp://www.tvgids.nl/detail.php?pid=" & strLinkprogramma & "&tab=3"
	End If
	temp = replace(temp, vbCr, "")
	temp = replace(temp, vbTab, "")
	temp = replace(temp, vbLf, "")
	temp = replace(temp, vbCrLf, "")
	temp = Trim(TrimHTML(temp))
	nowShowing = nowShowing & temp



	
	strAllInfo = Mid(strAllInfo, endPos+5)
	
	' get start time of what's on next
	startPos = InStr(strAllInfo, "<strong>") + 8
	endPos = InStr(strAllInfo, "</strong>")
	startTime = Mid(strAllInfo, startPos, (endPos-startPos))



	strAllInfo = Mid(strAllInfo, endPos+5)
	
	' get what's on next
	startPos = InStr(strAllInfo, "programma"">") + 11
	endPos = InStr(startPos, strAllInfo, "</a>") - 1

	If SHOW_STARTTIMES = True Then
		if InStr(startTime, ":")<1 Then
			nextShowing = ""
		Else
			nextShowing = "(" & TrimHTML(startTime) & ") "
		End If
	End If

	' next line added to support hyperlinks
	strLinkprogramma = Mid(strAllInfo, InStr(strAllInfo, "pid=")+4, 7)

	If startPos > 0 and endPos > 0 Then

	' clean up the string
	temp = Mid(strAllInfo, startPos, (endPos-startPos))
	else
	temp = ""
	end if
	' next If-statement added to support hyperlinks
	If IsNumeric(strLinkprogramma) Then
	temp = temp & "%lhttp://www.tvgids.nl/detail.php?pid=" & strLinkprogramma & "&tab=3"
	End If
	temp = replace(temp, vbCr, "")
	temp = replace(temp, vbTab, "")
	temp = replace(temp, vbLf, "")
	temp = replace(temp, vbCrLf, "")
	temp = Trim(TrimHTML(temp))
	nextShowing = nextShowing & temp

	
	' return listing
	getListing = channelName & vbCrlf & nowShowing & vbCrlf & nextShowing

End Function




Private Function ReturnHTML(sURL)
	Dim objXMLHTTP,HTML
	Set objXMLHTTP = CreateObject("Microsoft.XMLHTTP")
	Randomize
	sURL = sURL & "?" & Rnd
	objXMLHTTP.Open "GET", sURL, False
	objXMLHTTP.Send
	HTML = objXMLHTTP.responseBody
	Set objRS = CreateObject("ADODB.Recordset")
	objRS.Fields.Append "txt", 200, 45000, &H00000080
	objRS.Open
	objRS.AddNew
	objRS.Fields("txt").AppendChunk HTML
	ReturnHTML = objRS("txt").Value
	objRS.Close
	Set objRS = Nothing
	Set objXMLHTTP = Nothing
End Function


'very simple function that will remove all html tags
Private Function TrimHTML(str)
pos_deb = InStr(1, str, "<")
Do Until pos_deb = 0
    pos_fin = InStr(pos_deb, str, ">")
    part_d = Mid(str, 1, pos_deb - 1)
    part_f = Mid(str, pos_fin + 1, Len(str) - pos_fin)
    str = part_d & part_f
    pos_deb = InStr(1, str, "<")
Loop
TrimHTML = Trim(str)
End Function