' ============================================================================
' DutchWeather.vbs v1.01 - LvdR
'
' THE WMO IS THE ONLYTHING YOU HAVE TO SET, you can find it in the url of any page of the city of your choice, I only tested it for www.weeronline.nl
'
' ============================================================================

' Retrieves WeatherInfo from 
'	temperature: 
WMO="06344" 'this is the code for Rotterdam, update it with the WMO of the city of your choice, look at the url of the city at www.weeronline.nl
LANG="nl"

'part to automaticly search SID
SID_URL="http://www.weeronline.nl/cgi-bin/region?PRG=citybild&WMO="&WMO&"&LANG="&LANG

SID_Content = ReturnHTML(SID_URL)

	startPos = InStr(SID_Content , "SID=") + 4
	SID_Content = Mid(SID_Content , startPos )
	endPos = InStr(SID_Content, """") - 1

	SID = Mid(SID_Content, 1, endPos)

' temperature
TEMP_URL = "http://www.weeronline.nl/cgi-bin/citybild?SID="&SID&"&WMO="&WMO&"&LANG="&LANG
'	wind: 
WIND_URL = "http://www.weeronline.nl/cgi-bin/citywind?SID="&SID&"&WMO="&WMO&"&LANG="&LANG

' Made by leon_ree@hotmail.com
' Build up on script for DutchTV from NeM

' ======
' USAGE:
' ======

' 1) Copy DutchWeahther.vbs to your Samurize/scripts folder

' 2) Add an ActiveScript meter to your Samurize config with this script
'    selected and 'generateListing' selected as the Function.

' 3) Use TextFile meters to view the Weather. Each day has 9 
'    lines of information and is listed in the following order:

'	day
'	min. temperature
'	max. temperature
'	sunshine in the morning
'	sunshine in the midday
'	sunshine in the evening
'	wind force in the morning
'	wind force in the midday
'	wind force in the evening

'    So, for example, to see the listings for tomorow, Add a TextFile meter, point
'    it to the DutchTV.txt file, set the Read Line field to 10 and the Number
'    of Lines field to 9.


' ============================================================================
' USER SETTINGS
' ============================================================================

' ============================================================================

FILE_NAME = "DutchWeather.txt"

Function generateListing()

	Dim fs,f,htmlResult,textToWrite

	temp_htmlResult = ReturnHTML(TEMP_URL)
	wind_htmlResult = ReturnHTML(WIND_URL)
	
	For dayNumber=1 To 3
		textToWrite = textToWrite & parse_tempHTML(dayNumber, temp_htmlResult,TEMP_URL) & vbCrlf
		textToWrite = textToWrite & parse_windHTML(dayNumber, wind_htmlResult,WIND_URL) & vbCrlf
	Next
	
	set fs=CreateObject("Scripting.FileSystemObject")
	set f=fs.CreateTextFile(FILE_NAME,true)
	f.write(textToWrite)
	f.close
	set f=nothing
	set fs=nothing

End Function




Private Function parse_tempHTML(dayNumber, htmlResult, url)

	' first cut everything before <table width="415" border="1" cellspacing="0" cellpadding="1" BGCOLOR="#ffffff">
	start = InStr(htmlResult, "<table width=""415"" border=""1"" cellspacing=""0"" cellpadding=""1"" BGCOLOR=""#ffffff"">")
	If (start = 0) Then 
		parse_tempHTML="check SID and WMO, because I think the URL has changed!!!"
		Exit Function
	End If
	strAllInfo = Mid(htmlResult, start)

	' cut everything after the end of the weather info
	endWeatherTable = InStr(strAllInfo, " </table>")
	strAllInfo = Mid(strAllInfo, 1, endWeatherTable)



	' go to day 'dayNumber' and get it's name
	For i=1 To dayNumber
		startPos = InStr(strAllInfo, "<b>") + 3
		strAllInfo = Mid(strAllInfo, startPos )
	Next 
	endPos = InStr(strAllInfo, "</b>") - 1

	weatherDay = Mid(strAllInfo, 1, endPos)


	' go to day 'dayNumber' and get it's mininum temperature
	strAllInfo = Mid(strAllInfo, InStr(strAllInfo, "<tr"))
	For i=1 To dayNumber
		startPos = InStr(strAllInfo, "<b>") + 3
		strAllInfo = Mid(strAllInfo, startPos )
	Next 
	endPos = InStr(strAllInfo, "</b>") - 1

	weatherMinTemp = removeHTMLsymbols(Mid(strAllInfo, 1, endPos))


	' go to day 'dayNumber' and get it's maximum temperature
	strAllInfo = Mid(strAllInfo, InStr(strAllInfo, "<tr"))
	For i=1 To dayNumber
		startPos = InStr(strAllInfo, "<b>") + 3
		strAllInfo = Mid(strAllInfo, startPos )
	Next 
	endPos = InStr(strAllInfo, "</b>") - 1

	weatherMaxTemp = removeHTMLsymbols(Mid(strAllInfo, 1, endPos))


	' go to day 'dayNumber' and get info for the morning
	strAllInfo = Mid(strAllInfo, InStr(strAllInfo, "<tr"))
	For i=1 To dayNumber
		startPos = InStr(strAllInfo, "ALT=""") + 5
		strAllInfo = Mid(strAllInfo, startPos )
	Next 
	endPos = InStr(strAllInfo, """") - 1

	weatherMorning = Mid(strAllInfo, 1, endPos)


	' go to day 'dayNumber' and get info for the midday
	strAllInfo = Mid(strAllInfo, InStr(strAllInfo, "<tr"))
	For i=1 To dayNumber
		startPos = InStr(strAllInfo, "ALT=""") + 5
		strAllInfo = Mid(strAllInfo, startPos )
	Next 
	endPos = InStr(strAllInfo, """") - 1

	weatherMidday = Mid(strAllInfo, 1, endPos)


	' go to day 'dayNumber' and get info for the evening
	strAllInfo = Mid(strAllInfo, InStr(strAllInfo, "<tr"))
	For i=1 To dayNumber
		startPos = InStr(strAllInfo, "ALT=""") + 5
		strAllInfo = Mid(strAllInfo, startPos )
	Next 
	endPos = InStr(strAllInfo, """") - 1

	weatherEvening = Mid(strAllInfo, 1, endPos)


	' return listing
	parse_tempHTML = weatherDay & vbCrlf & weatherMinTemp & "%l" & url & vbCrlf & weatherMaxTemp & "%l" & url & vbCrlf & weatherMorning & "%l" & url & vbCrlf & weatherMidday & "%l" & url & vbCrlf & weatherEvening & "%l" & url 

End Function




Private Function parse_windHTML(dayNumber, htmlResult, url)


	' first cut everything before <table width="420" border="1" cellspacing="0" cellpadding="1" BGCOLOR="#ffffff">
	start = InStr(htmlResult, "<table width=""420"" border=""1"" cellspacing=""0"" cellpadding=""1"" BGCOLOR=""#ffffff"">")
	If (start = 0) Then 
		parse_windHTML="check SID and WMO, because I think the URL has changed!!!"
		Exit Function
	End If
	strAllInfo = Mid(htmlResult, start)


	' cut everything after the end of the weather info
	endWeatherTable = InStr(strAllInfo, " </table>")
	strAllInfo = Mid(strAllInfo, 1, endWeatherTable)


	' go to day 'dayNumber' and get it's name
	For i=1 To dayNumber
		startPos = InStr(strAllInfo, "<b>") + 3
		strAllInfo = Mid(strAllInfo, startPos )
	Next 
	endPos = InStr(strAllInfo, "</b>") - 1

	weatherDay = Mid(strAllInfo, 1, endPos)


	' go to day 'dayNumber' and get the wind force in the morning
	strAllInfo = Mid(strAllInfo, InStr(strAllInfo, "<tr"))
	For i=1 To dayNumber
		startPos = InStr(strAllInfo, "<b>") + 3
		strAllInfo = Mid(strAllInfo, startPos )
	Next 
	endPos = InStr(strAllInfo, "</b>") - 1

	windMorning = removeHTMLsymbols(Mid(strAllInfo, 1, endPos))


	' go to day 'dayNumber' and get the wind force in the midday
	strAllInfo = Mid(strAllInfo, InStr(strAllInfo, "<tr"))
	For i=1 To dayNumber
		startPos = InStr(strAllInfo, "<b>") + 3
		strAllInfo = Mid(strAllInfo, startPos )
	Next 
	endPos = InStr(strAllInfo, "</b>") - 1

	windMidday = removeHTMLsymbols(Mid(strAllInfo, 1, endPos))


	' go to day 'dayNumber' and get the wind force in the evening
	strAllInfo = Mid(strAllInfo, InStr(strAllInfo, "<tr"))
	For i=1 To dayNumber
		startPos = InStr(strAllInfo, "<b>") + 3
		strAllInfo = Mid(strAllInfo, startPos )
	Next 
	endPos = InStr(strAllInfo, "</b>") - 1

	windEvening = removeHTMLsymbols(Mid(strAllInfo, 1, endPos))


	' return listing
	parse_windHTML = windMorning & "%l" & url & vbCrlf & windMidday  & "%l" & url & vbCrlf & windEvening & "%l" & url

End Function




Private Function ReturnHTML(sURL)
	Dim objXMLHTTP,HTML
	Set objXMLHTTP = CreateObject("Microsoft.XMLHTTP")
	Randomize
	sURL = sURL & "?" & Rnd
	objXMLHTTP.Open "GET", sURL, False
	objXMLHTTP.Send
	HTML = objXMLHTTP.responseBody
	Set objRS = CreateObject("ADODB.Recordset")
	objRS.Fields.Append "txt", 200, 45000, &H00000080
	objRS.Open
	objRS.AddNew
	objRS.Fields("txt").AppendChunk HTML
	ReturnHTML = objRS("txt").Value
	objRS.Close
	Set objRS = Nothing
	Set objXMLHTTP = Nothing
End Function


'very simple function that will remove all html tags
Private Function TrimHTML(str)
pos_deb = InStr(1, str, "<")
Do Until pos_deb = 0
    pos_fin = InStr(pos_deb, str, ">")
    part_d = Mid(str, 1, pos_deb - 1)
    part_f = Mid(str, pos_fin + 1, Len(str) - pos_fin)
    str = part_d & part_f
    pos_deb = InStr(1, str, "<")
Loop
TrimHTML = Trim(str)
End Function


'very simple function that will remove all html tags
Private Function removeHTMLsymbols(str)
	str = replace(str,"&nbsp;"," ")
	str = replace(str,"&deg;","")
	str = replace(str,"  "," ")
	removeHTMLsymbols = trim(str)
End Function

