' ============================================================================
' DutchWind.vbs v1.03 - LvdR
' ============================================================================

' Retrieves Wind Info from 
WIND_URL = "http://www.actuelewaterdata.nl/cgi-bin/tabel.cgi/Marollegat-snelh-stoot?template=wind"

' Made by leon_ree@hotmail.com
' Build up on script for DutchTV from NeM

' ======
' USAGE:
' ======

' 1) Copy DutchWind.vbs to your Samurize/scripts folder

' 2) Add an ActiveScript meter to your Samurize config with this script
'    selected and 'getCurrentWindForce' selected as the Function.

' ============================================================================
' USER SETTINGS
' ============================================================================


FILE_NAME = "DutchWind.txt"

' ============================================================================

Function generateWindForceList()

	Dim wind_htmlResult

	Dim fs,f,htmlResult,textToWrite

	
	wind_htmlResult = ReturnHTML(WIND_URL)

	windForceList = parse_windHTML(wind_htmlResult)


	textToWrite = windForceList

	set fs=CreateObject("Scripting.FileSystemObject")
	set f=fs.CreateTextFile(FILE_NAME,true)
	f.write(textToWrite)
	f.close
	set f=nothing
	set fs=nothing
	
End Function




Private Function parse_windHTML(htmlResult)


	' go to current wind speed
	startPos = InStr(htmlResult, "<br/>---") + 8
	strAllInfo = Mid(htmlResult, startPos )

	windForcesAndBlasts = ""

	'find first time
	startPos = InStr(strAllInfo, ":") -2
	timeNow = Mid(strAllInfo, startPos, 5)

	for i=1 to 24
		'find last time
		if (i=24) then
			startPos = InStr(strAllInfo, ":") -2
			timeLast = Mid(strAllInfo, startPos, 5)
		end if

		startPos = InStr(strAllInfo, "&nbsp;&nbsp;&nbsp;") + 18
		strAllInfo = Mid(strAllInfo, startPos )

		endPos = InStr(strAllInfo, "<br/>") - 2

		windSpeed = Mid(strAllInfo, 1, endPos)

		windForce = convert_toBft(windSpeed)

		windForcesAndBlasts = windForcesAndBlasts & windForce & vbCrlf
	next

	startPos = InStr(strAllInfo, "<br/>---") + 8
	strAllInfo = Mid(strAllInfo, startPos )

	for i=1 to 24
		startPos = InStr(strAllInfo, "&nbsp;&nbsp;&nbsp;") + 18
		strAllInfo = Mid(strAllInfo, startPos )

		endPos = InStr(strAllInfo, "<br/>") - 2

		windSpeed = Mid(strAllInfo, 1, endPos)

		windForce = convert_toBft(windSpeed)

		windForcesAndBlasts = windForcesAndBlasts & windForce & vbCrlf
	next

	windForcesAndBlasts = windForcesAndBlasts & timeNow & vbCrlf
	windForcesAndBlasts = windForcesAndBlasts & timeLast & vbCrlf

	parse_windHTML = windForcesAndBlasts

End Function


Private Function convert_toBft(windSpeed)

	windSpeed = trim(windSpeed)

	if (lcase(windSpeed) = "nvt") then 
		windForce = 0
	elseif (windSpeed <= 0.2) then 
		windForce = 0
	elseif (windSpeed <= 1.5) then
		windForce = 1
	elseif (windSpeed <= 3.3) then 
		windForce = 2
	elseif (windSpeed <= 5.4) then 
		windForce = 3
	elseif (windSpeed <= 7.9) then 
		windForce = 4
	elseif (windSpeed <= 10.7) then 
		windForce = 5
	elseif (windSpeed <= 13.8) then 
		windForce = 6
	elseif (windSpeed <= 17.1) then 
		windForce = 7
	elseif (windSpeed <= 20.7) then 
		windForce = 8
	elseif (windSpeed <= 24.4) then 
		windForce = 9
	elseif (windSpeed <= 28.4) then 
		windForce = 10
	elseif (windSpeed <= 32.6) then 
		windForce = 11
	else
		windForce = 12
	end if

	convert_toBft = windForce

End Function


Private Function ReturnHTML(sURL)
	Dim objXMLHTTP,HTML
	Set objXMLHTTP = CreateObject("Microsoft.XMLHTTP")
	Randomize
	sURL = sURL & "?" & Rnd
	objXMLHTTP.Open "GET", sURL, False
	objXMLHTTP.Send
	HTML = objXMLHTTP.responseBody
	Set objRS = CreateObject("ADODB.Recordset")
	objRS.Fields.Append "txt", 200, 45000, &H00000080
	objRS.Open
	objRS.AddNew
	objRS.Fields("txt").AppendChunk HTML
	ReturnHTML = objRS("txt").Value
	objRS.Close
	Set objRS = Nothing
	Set objXMLHTTP = Nothing
End Function


'very simple function that will remove all html tags
Private Function TrimHTML(str)
pos_deb = InStr(1, str, "<")
Do Until pos_deb = 0
    pos_fin = InStr(pos_deb, str, ">")
    part_d = Mid(str, 1, pos_deb - 1)
    part_f = Mid(str, pos_fin + 1, Len(str) - pos_fin)
    str = part_d & part_f
    pos_deb = InStr(1, str, "<")
Loop
TrimHTML = Trim(str)
End Function


'very simple function that will remove all html tags
Private Function removeHTMLsymbols(str)
	str = replace(str,"&nbsp;"," ")
	str = replace(str,"&deg;","")
	str = replace(str,"  "," ")
	removeHTMLsymbols = trim(str)
End Function

