'Computes Used, Free and total space for all Logical disk drives.
'Version 1.0
'Created: 			March 5, 2003
'Last Modified:		March 23, 2003  
'Copyright 2003  Peter Giberson
'Not redistrubtable without express permission from author.
'Suitable for Windows 2000/Windows XP only.
'
'
'comments to pgiberson@hotmail.com 



'
' Calculate vUbytes (Total bytes used by all logical drives) 
'
Dim vDcnt, vFSpace, vUbytes, vTbytes

Function UsedSpace()

'To get Freespace to execute the read of the disks
'
vufspace = FreeSpace ()
vUbytes = TotalSpace() - vufspace

'
'No need to divide by a gigabyte Freespace and Totalspace did it for us.
'
UsedSpace = vUbytes

End Function

'
'  Make Totalbytes for all logical drives available in a function
'

Function TotalSpace()

'To get Filespace to read the disks for us
'
vtsfreebytes = Freespace()

'Convert to Gigabytes from bytes
'
vTbytes = Round((vTbytes / 1073741824),2)
TotalSpace = vTbytes

'
End Function

'-----------------------------------------------------
'Calculate Total FreeSpace
'-----------------------------------------------------
'
Function FreeSpace()


On Error Resume Next 

' Connect to WMI and obtain instances of Win32_LogicalDisk
vsum1 = 0
vsum2 = 0
vFSpace = 0
vTbytes = 0

For Each objDD in GetObject("winmgmts:").InstancesOf ("Win32_LogicalDisk")
	if objDD.DriveType = 3  then
		vsum1 =  vsum1 + objDD.Freespace
        	vsum2 =  vsum2 + objDD.Size
	End if
Next

'Convert to Gigabytes
'
vFSpace =  Round((vsum1 / 1073741824),2)
vTbytes =  Round(vsum2 ,2)
FreeSpace = vFSpace


End Function

