 
   /*******************************************************/
  /**** SWEather XML v1.0 - uk.weather.com in Swedish ****/
 /**** by linuslovholm@hotmail.com                   ****/
/*******************************************************/


cityID      = "PLXX0028"; // Byt ut denna till din stads kod frn http://www.weather.com/
                          // Anvnd skfunktionen fr att hitta din stad och kopiera de 8 tecken som kommer efter
                          // "http://www.weather.com/weather/local/" i sk resultatet. Strunta i alla tecken efter dessa 8!

windUnit    = "m/s";     // Byt ut "km/h" mot "m/s" a konverterar scriptet automatiskt till meter per sekund


// Redigera fljande funktioner som du vill, fr att hmta din personliga
// sammansatta prognos. Mjliggr output ver flera rader etc. ("\r\n" r en ny rad)

function My_TodayWeather(){
  return TodayCondition() + "\r\n" +
  TodayTempFeel() + "\r\n" +
  TodayWindDir() + "\r\n" +
  TodayWindSpeed() + "\r\n" +
  TodayPrecipitationRisk() + "\r\n" +
  TodayHumidity() + "\r\n" +
  TodayPressure() + "\r\n" +
  TodayPressureTrend() + "\r\n" +
  LastMeasure() + "\r\n" +
  TodayVisibility() + "\r\n" +
  TodayUVIndex() + "\r\n" +
  TodaySunrise() + "\r\n" +
  TodaySunset();
}

function My_TonightWeather(){
  return TonightCondition() + "\r\n" +
  TonightWindSpeed() + "\r\n" +
  TonightWindDir() + "\r\n" +
  TonightPrecipitationRisk() + "\r\n" +
  TonightHumidity();
}

function My_Day2Weather(){
  return Day2Condition() + "\r\n" +
  Day2WindSpeed() + "\r\n" +
  Day2WindDir() + "\r\n" +
  Day2PrecipitationRisk() + "\r\n" +
  Day2Humidity() + "\r\n" +
  Day2Sunrise() + "\r\n" +
  Day2Sunset();
  }

function My_Day3Weather(){
  return Day3Condition() + "\r\n" +
  Day3WindSpeed() + "\r\n" +
  Day3WindDir() + "\r\n" +
  Day3PrecipitationRisk() + "\r\n" +
  Day3Humidity() + "\r\n" +
  Day3Sunrise() + "\r\n" +
  Day3Sunset();
  }

  /****************************************/
 /**** PUBLIC FUNCTIONS - DO NOT EDIT ****/
/****************************************/

function City(){var t = sys.getXML().selectSingleNode("//weather/loc/dnam").text; return t.substr(0,t.indexOf(","));}
function LastMeasure(){ return sys.to24HClock( sys.getXML().selectSingleNode("//weather/cc/lsup").text );}

function TodayDate(){return sys.getDate(0);}

function TodayTemp(){return sys.getXML().selectSingleNode("//weather/cc/tmp").text + "";}
function TodayTempFeel(){return sys.getXML().selectSingleNode("//weather/cc/flik").text + "";}
function TodayCondition(){return sys.translate(sys.getXML().selectSingleNode("//weather/cc/t").text);}
function TodaySymbol(){return sys.symbolize(sys.getXML().selectSingleNode("//weather/cc/icon").text);}
function TodayWindSpeed(){ var xml = sys.getXML(); return sys.convertWind(xml.selectSingleNode("//weather/cc/wind/s").text , xml.selectSingleNode("//weather/cc/wind/gust").text); }
function TodayWindDir(){return sys.windTranslate(sys.getXML().selectSingleNode("//weather/cc/wind/t").text);}
function TodayWindDirDeg(){return sys.toPercent(sys.getXML().selectSingleNode("//weather/cc/wind/d").text);}
function TodayPrecipitationRisk(){return sys.getXML().selectSingleNode("//weather/dayf/day/part/ppcp").text + "%";}
function TodayHumidity(){return sys.getXML().selectSingleNode("//weather/cc/hmid").text + "%";}
function TodaySunrise(){return sys.to24H( sys.getXML().selectSingleNode("//weather/loc/sunr").text );}
function TodaySunset(){return sys.to24H( sys.getXML().selectSingleNode("//weather/loc/suns").text );}
function TodayPressure(){return sys.getXML().selectSingleNode("//weather/cc/bar/r").text + " mb";}
function TodayPressureTrend(){return sys.translate(sys.getXML().selectSingleNode("//weather/cc/bar/d").text);}
function TodayDewPoint(){return sys.getXML().selectSingleNode("//weather/cc/dewp").text + "";} 
function TodayVisibility(){vis = sys.getXML().selectSingleNode("//weather/cc/vis").text;if(isNaN(vis)) return sys.translate(vis); else return vis + " km";}
function TodayUVIndex(){var xml = sys.getXML(); return xml.selectSingleNode("//weather/cc/uv/i").text + " " + sys.translate(xml.selectSingleNode("//weather/cc/uv/t").text);}

function TonightTemp(){return sys.getXML().selectSingleNode("//weather/dayf/day/low").text + "";} 
function TonightCondition(){return sys.translate(sys.getXML().selectNodes("//weather/dayf/day/part/t").item(1).text);}
function TonightSymbol(){return sys.symbolize(sys.getXML().selectNodes("//weather/dayf/day/part/icon").item(1).text);}
function TonightWindSpeed(){var xml = sys.getXML(); return sys.convertWind(xml.selectNodes("//weather/dayf/day/part/wind/s").item(1).text,xml.selectNodes("//weather/dayf/day/part/wind/gust").item(1).text);}
function TonightWindDir(){return sys.windTranslate(sys.getXML().selectNodes("//weather/dayf/day/part/wind/t").item(1).text);}
function TonightWindDirDeg(){return sys.toPercent(sys.getXML().selectNodes("//weather/dayf/day/part/wind/d").item(1).text);}
function TonightPrecipitationRisk(){return sys.getXML().selectNodes("//weather/dayf/day/part/ppcp").item(1).text + "%";}
function TonightHumidity(){return sys.getXML().selectNodes("//weather/dayf/day/part/hmid").item(1).text + "%";}

function Day2Date(){return sys.getDate(1);}
function Day2MinTemp(){return sys.getXML().selectNodes("//weather/dayf/day/low").item(1).text + "";} 
function Day2MaxTemp(){return sys.getXML().selectNodes("//weather/dayf/day/hi").item(1).text + "";} 
function Day2Condition(){return sys.translate(sys.getXML().selectNodes("//weather/dayf/day/part/t").item(2).text);}
function Day2Symbol(){return sys.symbolize(sys.getXML().selectNodes("//weather/dayf/day/part/icon").item(2).text);}
function Day2WindSpeed(){var xml = sys.getXML(); return sys.convertWind(xml.selectNodes("//weather/dayf/day/part/wind/s").item(2).text,xml.selectNodes("//weather/dayf/day/part/wind/gust").item(2).text);}
function Day2WindDir(){return sys.windTranslate(sys.getXML().selectNodes("//weather/dayf/day/part/wind/t").item(2).text);}
function Day2WindDirDeg(){return sys.toPercent(sys.getXML().selectNodes("//weather/dayf/day/part/wind/d").item(2).text);}
function Day2PrecipitationRisk(){return sys.getXML().selectNodes("//weather/dayf/day/part/ppcp").item(2).text + "%";}
function Day2Humidity(){return sys.getXML().selectNodes("//weather/dayf/day/part/hmid").item(2).text + "%";}
function Day2Sunrise(){return sys.to24H(sys.getXML().selectNodes("//weather/dayf/day/sunr").item(1).text);} 
function Day2Sunset(){return sys.to24H(sys.getXML().selectNodes("//weather/dayf/day/suns").item(1).text);} 

function Day3Date(){return sys.getDate(2);}
function Day3MinTemp(){return sys.getXML().selectNodes("//weather/dayf/day/low").item(2).text + "";} 
function Day3MaxTemp(){return sys.getXML().selectNodes("//weather/dayf/day/hi").item(2).text + "";} 
function Day3Condition(){return sys.translate(sys.getXML().selectNodes("//weather/dayf/day/part/t").item(4).text);}
function Day3Symbol(){return sys.symbolize(sys.getXML().selectNodes("//weather/dayf/day/part/icon").item(4).text);}
function Day3WindSpeed(){var xml = sys.getXML(); return sys.convertWind(xml.selectNodes("//weather/dayf/day/part/wind/s").item(4).text,xml.selectNodes("//weather/dayf/day/part/wind/gust").item(4).text);}
function Day3WindDir(){return sys.windTranslate(sys.getXML().selectNodes("//weather/dayf/day/part/wind/t").item(4).text);}
function Day3WindDirDeg(){return sys.toPercent(sys.getXML().selectNodes("//weather/dayf/day/part/wind/d").item(4).text);}
function Day3PrecipitationRisk(){return sys.getXML().selectNodes("//weather/dayf/day/part/ppcp").item(4).text + "%";}
function Day3Humidity(){return sys.getXML().selectNodes("//weather/dayf/day/part/hmid").item(4).text + "%";}
function Day3Sunrise(){return sys.to24H(sys.getXML().selectNodes("//weather/dayf/day/sunr").item(2).text);} 
function Day3Sunset(){return sys.to24H( sys.getXML().selectNodes("//weather/dayf/day/suns").item(2).text);} 


  /******************************************/
 /**** SYSTEM FUNCTIONS - DO *NOT* EDIT ****/
/******************************************/

var sys = new SystemObject();

  /***********************************************************/
 /**** System object to hide private functions from user ****/
/***********************************************************/
function SystemObject() {

if( !(this instanceof SystemObject) ) return new SystemObject( );    

baseURL           = "http://xoap.weather.com/weather/local/";
endURL            = "?cc=*&dayf=3&unit=m";
this.samurizeDir  = new ActiveXObject("WScript.Shell").RegRead("HKEY_CURRENT_USER\\Software\\Serious Samurize\\General\\DirPath");
this.symbolDir    = this.samurizeDir + "Scripts\\SWEatherSymbols\\";
filepath          = this.samurizeDir + "Scripts\\" + "SWEather.xml";
err               = "reload config";

  /******************************************************************/
 /**** Updates (if necessary) the file and returns its contents ****/
/******************************************************************/
this.getXML = function ()
{
  try
  {
    fs = new ActiveXObject("Scripting.FileSystemObject");
    if(fs.FileExists(filepath))
    {
      var file = fs.GetFile(filepath);
      if(this.timeToUpdate(new Date(file.DateLastModified)))
      {
        file.Delete();
        delete file;
        this.updateXML()
      }
    }
    else
    {
      this.updateXML()
    }

    xmlDoc = new ActiveXObject("Msxml2.DOMDocument");
    xmlDoc.async = false;
    xmlDoc.resolveExternals = false;
    xmlDoc.load(filepath);
    return xmlDoc;
  }
  catch(e)
  {
    return err;
  }
  finally
  {
    delete fs;
  }
}


  /***************************************/
 /**** Downloads new weather content ****/
/***************************************/
this.updateXML = function ()
{
  try
  {
    http = new ActiveXObject("Microsoft.XMLHTTP");
    http.Open("GET",baseURL + cityID + endURL + "&rnd="+Math.random(),false);   
    http.send();
    page = http.ResponseText;
    fs = new ActiveXObject("Scripting.FileSystemObject");
    file = fs.CreateTextFile(filepath, true, false);
    if(page == "")
      page == "<weather></weather>";
    file.Write(page);
    file.Close();
  }
  catch(e)
  {
  }
  finally
  {
    delete file;
    delete fs;
    delete http;
  }
}//END downloadNewContent

  /***********************************/
 /**** Checks if file is too old ****/
/***********************************/
this.timeToUpdate = function (filetime) {
    
  var now = new Date();
  var compareHigh = new Date();
  var compareLow = new Date();
  
  if(now.getMinutes()<24)
  {
    compareHigh.setHours(compareHigh.getHours()-1,54);
  }
  else
  {
    compareHigh.setMinutes(54);
  }

  compareLow.setMinutes(24);

  // If file is too old, return true
  if(  ( (now>compareHigh) && (compareHigh>filetime) ) || 
       ( (now>compareLow ) && (compareLow>filetime ) )  )
  {
    return true;
  }
  return false;
    
}//END timeToUpdate

  /******************************************************************/
 /**** Retrieves day and date with a specific offset from today ****/
/******************************************************************/
this.getDate = function (offset){
  var temp = new Date();
  var day = "";
  temp.setFullYear(temp.getYear(),temp.getMonth(),temp.getDate()+offset);
  switch (temp.getDay()) {
      case 0 : day = "Niedziela"; break;
      case 1 : day = "Poniedzialek"; break;
      case 2 : day = "Wtorek"; break;
      case 3 : day = "Sroda"; break;
      case 4 : day = "Czwartek"; break;
      case 5 : day = "Piatek"; break;
      case 6 : day = "Sobota"; break;
  }
  return day + " " + temp.getDate() + "/" + (temp.getMonth()+1);
}//END getDate

  /***************************************************/
 /**** Translates symbol numbers to icon numbers ****/
/***************************************************/
this.symbolize = function (i){
  i = parseInt(i);
  switch (i) {
    case 0: i = "15"; break;
    case 1: i = "32"; break;
    case 2: i = "18"; break;
    case 3: i = "15"; break;
    case 4: i = "15"; break;
    case 5: i = "29"; break;
    case 6: i = "25"; break;
    case 7: i = "29"; break;
    case 8: i = "12"; break;
                   
    case 9: i =  "8"; break;
    case 10: i = "29"; break;
    case 11: i = "13"; break;
    case 12: i = "12"; break;
    case 13: i = "20"; break;
    case 14: i = "19"; break;
    case 15: i = "24"; break;
    case 16: i = "22"; break;
    case 17: i = "15"; break;
    case 18: i = "26"; break;

    case 19: i = "11"; break;
    case 20: i = "11"; break;
    case 21: i = "05"; break;
    case 22: i = "11"; break;
    case 25: i = "31"; break;
    case 26: i = "7"; break;
    case 27: i = "36"; break;
                    
    case 28: i = "6"; break;
    case 29: i = "34"; break;
    case 30: i = "2"; break;
    case 31: i = "33"; break;
    case 32: i = "1"; break;
    case 33: i = "37"; break;
    case 34: i = "5"; break;
                    
    case 35: i = "15"; break;
    case 36: i = "30"; break;
    case 37: i = "15"; break;
    case 38: i = "15"; break;
    case 39: i = "12"; break;
    case 40: i = "18"; break;
    case 41: i = "19"; break;
    case 42: i = "22"; break;
    case 43: i = "25"; break;
    case 44: i = "3"; break;
    case 45: i = "40"; break;
    case 46: i = "43"; break;

  }
  return this.symbolDir + i + ".png";
}

  /**********************************/
 /**** AM/PM clock to 24h clock ****/
/**********************************/
this.to24HClock = function (t){
  // Extract only time part
  t = t.substr(t.indexOf(" ")+1);
  t = t.substr(0,t.indexOf(" ")+3);
  return this.to24H(t);
}

this.to24H = function (t){
  i = t.indexOf(":"); 
  if(t.indexOf("AM") != -1)
    return t.substr(0,i+3);
  return (parseInt(t.substr(0,i))+12) + t.substr(i,3);
}
  
  /****************************/
 /**** 360 deg to percent ****/
/****************************/
this.toPercent = function (t){
  return parseInt((t / 360) * 100);
}

  /**********************************************************/
 /**** Translates weather terms from English to Swedish ****/
/**********************************************************/
this.translate = function (str){
  str = new String(str);
  str = str.replace(/Unlimited/g, "Ultimated");
  str = str.replace(/Unknown|N\/A/g, "Unknow");
  str = str.replace(/Ice/g, "Ice");
  str = str.replace(/Late/g, "Late");
  str = str.replace(/Early/g, "Early");
  str = str.replace(/Hail/g, "Hail");
  str = str.replace(/Hail Showers*/g, "Hail Showers");
  str = str.replace(/Snow to Rain/g, "Snow to Rain");
  str = str.replace(/Rain to Snow/g, "Rain to Snow");
  str = str.replace(/Chilled/g, "Chilled");
  str = str.replace(/Fog|Mist/g, "Fog|Mist");
  str = str.replace(/PM/g, "PM:");
  str = str.replace(/AM/g, "AM:");
  str = str.replace(/Partly Cloudy/g, "Partly Cloudy");
  str = str.replace(/Snow Showers*/g, "Snow Showers");
  str = str.replace(/Light Snow Showers*/g, "Light Snow Showers");
  str = str.replace(/Partly/g, "Partly");
  str = str.replace(/Mostly/g, "Mostly");
  str = str.replace(/Cloudy/g, "Cloudy");
  str = str.replace(/Haze/g, "Haze");
  str = str.replace(/and/g, "&");
  str = str.replace(/Wintry Mix/g, "Wintry Mix");
  str = str.replace(/Few/g, "Few");
  str = str.replace(/Windy*/g, "Windy");
  str = str.replace(/Drizzle/g, "Drizzle");
  str = str.replace(/T-Storms/g, "T-Storms");
  str = str.replace(/Storms/g, "Storms");
  str = str.replace(/Storm/g, "Storm");
  str = str.replace(/Light Showers*/g, "Light Showers");
  str = str.replace(/Rain Shower/g, "Rain Shower");
  str = str.replace(/Snow Shower/g, "Snow Shower");
  str = str.replace(/Light/g, "Light");
  str = str.replace(/Heavy/g, "Heavy");
  str = str.replace(/Snow/g, "Snow");
  str = str.replace(/Rain/g, "Rain");
  str = str.replace(/Showers*/g, "Showers");
  str = str.replace(/Clear/g, "Clear");
  str = str.replace(/Hot/g, "Hot");
  str = str.replace(/Overcast/g, "Overcast");
  str = str.replace(/Calm/gi, "Calm");
  str = str.replace(/Sunny/g, "Sunny");
  str = str.replace(/Sun/g, "Sun");
  str = str.replace(/Wet/g, "Wet");
  str = str.replace(/Scattered/g, "Scattered");
  str = str.replace(/Flurries/g, "Flurries");
  str = str.replace(/Fair/g, "Fair");
  str = str.replace(/Breeze/g, "Breeze");
  str = str.replace(/  /g, " ");
  str = str.replace(/gusting to/g, "-");
  str = str.replace(/to/g, "-");
  str = str.replace(/From the /g, "");
  str = str.replace(/High/g, "High");
  str = str.replace(/Moderate/g, "Moderate");
  str = str.replace(/Low/g, "Low");
  str = str.replace(/Minimal/g, "Minimal");
  str = str.replace(/Steady/gi, "Steady");
  str = str.replace(/Rising/gi, "Rising");
  str = str.replace(/Falling/gi, "Falling");
  str = str.replace(/Unsteady/gi, "Unsteady");
  str = str.replace(/Unstable/gi, "Unsteady");
  str = str.replace(/Instabile/gi, "Unsteady"); 
  str = str.replace(/N\/A/g, "");

  return str;
}//END translate

this.windTranslate = function (str){
  switch (str) {
    case "NNW" : str = "Nord-nordvst"; break;
    case "NNE" : str = "Nord-nordost"; break;
    case "SSW" : str = "Syd-sydvst"; break;
    case "SSE" : str = "Syd-sydost"; break;
    case "ENE" : str = "Ost-nordost"; break;
    case "ENW" : str = "Ost-nordvst"; break;
    case "WNE" : str = "Vst-nordost"; break;
    case "WNW" : str = "Vst-nordvst"; break;
    case "ESE" : str = "Ost-sydost"; break;
    case "ESW" : str = "Ost-sydvst"; break;
    case "WSE" : str = "Vst-sydost"; break;
    case "WSW" : str = "Vst-sydvst"; break;
    case "NE" : str = "Nordost"; break;
    case "NW" : str = "Nordvst"; break;
    case "SW" : str = "Sydvst"; break;
    case "SE" : str = "Sydost"; break;
    case "N"  : str = "Nord"; break;
    case "S"  : str = "Syd"; break;
    case "W"  : str = "Vst"; break;
    case "E"  : str = "Ost"; break;
  }
  return str;
}// END windTranslate

  /*******************************************/
 /**** Converts digest windspeed to full ****/
/*******************************************/
this.convertWind = function (w,g){  
  if(isNaN(g))
    return this.convert(w);
  return this.convert(w) + ", byar " + this.convert(g);

}// END convertWind

  /*****************************************************/
 /**** Removes all white space characters in "str" ****/
/*****************************************************/
this.trim = function (str){
  str = str.replace(/\s/gi, "");
  return str;
}//END trim

  /*************************************/
 /**** Converts mps to km/h or m/s ****/
/*************************************/
this.convert = function (val){  
  val = new String(val);
  if(this.trim(val) == "calm")
    return "0 " + windUnit;

  if(windUnit == "km/h")
    return val + " " + windUnit;;
  
  var temp = new String( val / 3.6 );
  var rest = temp.substr(temp.indexOf(".")+1,1);
  if(rest != "")
    rest = "." + parseFloat(Math.round(rest));
  temp = new String( parseInt(temp) );
  return temp + rest + " " + windUnit;
  
}//END convert


}//END SystemObject