' WeatherCan 2.2 by gdeluca
' Another weather script. This uses the Canadian Government weather site
' http://weatheroffice.ec.gc.ca as the data source.  Well, that's the main URL,
' the data is fetched from the PDA support pages at:
' http://www.weatheroffice.pyr.ec.gc.ca/pda/introduction_e.html
'
' Version history contained within the WeatherCanReadMe.txt file
'
'------- Set some options here --------------------------------------------------------
'  * Metric support is provided for all individual data fields. It is NOT provided for the
'    long text forecast (line 60 in the output file) since this is provided as a free format
'    text paragraph with embedded metric values. If anyone feels like providing code to handle
'    this conversion, feel free to write it and forward it to me - Have fun!
'  * Although the web site supports many international cities, the script may NOT always
'    handle them successfully since the displayed web page is formatted differently.
'    Some basic data will be fine, some won't. YMMV.  Also many smaller Canadian cities and
'    towns may also not produce ALL the values as they have no complete data collection
'    facilities.  
'    If the script REALLY fouls up on a particular selection, please post a message as a 
'    Comment to the download file on Samurize.com, or send me an e-mail directly
'    (gddeluca@bigfoot.com) and I'll try and make it cope enough to be functional.
'  * The WEATHERCANDIRECTORY below should be set to the WeatherCan directory (Normally this
'    will be "C:\Program Files\Samurize\WeatherCan\"
'  * The WRAPxxxxxx variables below control the length of output lines for the various textual
'    output fields. This will cause the text to be word-wrapped at the specified boundaries
'    to assist in formatting within Samurize text meter boundaries. Note the wrap is specified
'    in 'characters'.
'  * To find your city's URL, just go to the "http://weatheroffice.ec.gc.ca" site and step 
'    through the maps etc. till you reach your desired city.  Note the city code in the URL. 
'    It is usually the last 3 characters. 
'      e.g. Hamilton Ontario URL is http://weatheroffice.ec.gc.ca/forecast/city_e.html?YHM 
'    The code to enter for GETCITY would be "&city=YHM"
'  * The METRIC keyword should be set to True to receive metric values, to False to receive
'    data values converted to Imperial measures (Fahrenheit, inches, miles, etc.)
'  * The GMTREQ value specifies how the timestamp of the forecast should be handled. The default 
'    of "99" will convert it to your systems local time. If you are monitoring weather for a
'    city which is NOT in your local time zone, then specify here the needed GMT offset for that
'    city.
Const GETCITY = "&city=yhm"
Const METRIC = True											' Data returned in Metric, False = 'English'
Const GMTREQ = "99"											' 99 = Convert GMT to local system time zone
'																	' nn = Adjust by this value (00 = leave as GMT)
'																	'      Values may be +ve or -ve
Const WEATHERCANDIRECTORY = "C:\Program Files\Samurize\WeatherCan\"
Const WRAPCURRENT = 80										' Word-wrap margin of Current conditions
Const WRAPFORECASTSHORT = 18			 					' Word-wrap margin of Short text forecasts
Const WRAPFORECASTLONG = 48					 			' Word-wrap margin of Long text forecast
'------- Change lines below only if you know what you're doing! -----------------------
Dim restart

'------- Fetch the Web data and extract the key data from it --------------------------
Function FetchPage
	Const WINDDIR = "    S   SSW SW  WSW W   WNW NW  NNW  N   NNE NE  ENE E   ESE SE  SSE "
	Const GETURL = "http://www.weatheroffice.pyr.ec.gc.ca/pda/citygen_e.html?Client=PDACD"
	Const GETCUR = "N_e"
	Const GETALM = "NA_e"
	Const GETFOR = "NF_e"
	Const GETTXT = "NT_e"
	Dim w(60)
	for i = 1 to 60: w(i) = "": next 
	Randomize(Time())
'------------- Get GMT Offset --------------------------------------------------------
	strComputer = "."
	Set objWMIService = GetObject("winmgmts:" & "{impersonationLevel=impersonate}!\\" & strComputer & "\root\cimv2")
	Set colTimeZone = objWMIService.ExecQuery ("Select * from Win32_TimeZone")
	For Each objTimeZone in colTimeZone
		gmt = objTimeZone.Bias
	Next
	Set colTimeZone = Nothing
	Set objWMIService = Nothing
	gmt = gmt / 60
	if GMTREQ <> "99" then gmt = GMTREQ
	'------- Establish the Output file Name --------------------------------------------
 	set fs=CreateObject("Scripting.FileSystemObject")			' Access the file system
	tp = WEATHERCANDIRECTORY & "WeatherCan.txt"					' Create full path to O/P file
	'------- Get the time of the last Web report from any existing file ----------------
	if fs.fileexists(tp) then
		set f = fs.OpenTextFile(tp, 1)
		LTime = f.ReadLine
		f.Close
		set f = nothing
	else
		LTime = "0"
	end if
	'LTime = "0"															' Uncomment for testing
	'------- Fetch the Web Page --------------------------------------------------------
	HtmlData = ""
	Set Http = CreateObject("Microsoft.XMLhttp")
	Http.Open "GET",GETURL & GETCUR & GETCITY & "&random=" & rnd, False
	Http.Send
	HtmlData = BinToText(Http.ResponseBody, Len(Http.ResponseBody))
	Set Http = Nothing
	HtmlData = Clean(HtmlData,"crap","crap")
	'wscript.echo HtmlData												' Uncomment for testing
	if len(HtmlData) > 0 then
		'------- Get Report Time from web page, exit if unchanged ----------------------
		w(1) = GetHTMLWords(1,"Observed on:",5,HtmlData)
		w(1) = Replace(w(1), "at", " ")
		w(1) = DateAdd("h",gmt,w(1))
		w(1) = WeekDayName(WeekDay(w(1)),True) & " at " & Right(w(1),11)
		if LTime = w(1) then exit function
		'------- Get the current conditions information --------------------------------
		ic = NextHTMLValue(1,"/icons3/",".gif",HtmlData)
		If ic = "N/A" then ic = "29" else ic = right("00" & ic, 2)
		w(15) = WEATHERCANDIRECTORY & ic & ".png"
		w(16) = WordWrap(NextHTMLValue(0,">","Temp.:",HtmlData),WRAPCURRENT)
		w(17) = NextHTMLValue(0,"Temp.:","Pressure:",HtmlData)
		if not Metric then w(17) = Round(((1.8*left(w(17),len(w(17))-2))+32),0) & "F"
		w(18) = NextHTMLValue(0,"Pressure:","Visibility",HtmlData)
		if not Metric then w(18) = Round((.2953*left(w(18),len(w(18))-3)),1) & "in"
		w(19) = NextHTMLValue(0,"Visibility:","Humidity",HtmlData)
		if not Metric then w(19) = round((0.621*left(w(19),len(w(19))-2)),0) & "mi"
		w(20) = NextHTMLValue(0,"Humidity:","%",HtmlData) & "%"
		w(21) = NextHTMLValue(0,"DewPoint:","Wind:",HtmlData)
		if not Metric AND W(21) <> "N/A" then _
			w(21) = Round(((1.8*left(w(21),len(w(21))-2))+32),0) & "F"
		'------- Select which of WindChill / Humidex gets output -----------------------
		wc = NextHTMLValue(1,"WindChill:","Wind:",HtmlData)
		hm = NextHTMLValue(1,"Humidex:","Wind:",HtmlData)
		if wc = "N/A" and hm = "N/A" then
			w(22) = " ": w(23) = " "
		elseif wc <> "N/A" then
			w(22) = "WindChill": w(23) = wc
			if not Metric then w(23) = Round(((1.8*w(23))+32),0)
		else
			w(22) = "Humidex": w(23) = hm
			if not Metric then w(23) = Round(((1.8*w(23))+32),0)
		end if
		'------- Get the Wind Speed and Direction, Reduce to essentials ----------------
		tt = InStr(HtmlData,"Wind:")
		tt = mid(HtmlData,tt+5)
		if tt <> "N/A" then
			ti = instr(tt,"km/h")
			if ti <> 0 then
				td = "": ts = ""
				for I = 1 to ti - 1
					if isnumeric(mid(tt,I,1)) then ts = ts & mid(tt,I,1)
					if not isnumeric(mid(tt,I,1)) then td = td & mid(tt,I,1)
				next
			end if
			if not Metric then ts = round((0.621*ts),0)
			if not Metric then 
				w(24) = Trim(td) & "@" & Trim(ts) & "mi/h"
			else
				w(24) = Trim(td) & "@" & Trim(ts) & "km/h"
			end if
			'---- Create the Compass Rose percentage for Wind Dir. ----------------------
			w(25) = td
			td = left(td & "   ",4)
			w(26) = ts
			w(27) = ((instr(WINDDIR, td) - 4)-1) * 1.5625
		else
			w(24) = "N/A": w(25) = "N/A": w(26) = "N/A": w(27) = "0"
		end if
		'------- Get the Almanac type data ---------------------------------------------
		HtmlData = ""
		Set Http = CreateObject("Microsoft.XMLhttp")
		Http.Open "GET",GETURL & GETALM & GETCITY & "&random=" & rnd, False
		Http.Send
		HtmlData = BinToText(Http.ResponseBody, Len(Http.ResponseBody))
		Set Http = Nothing
		HtmlData = Clean(HtmlData,"crap","crap")
		tt = InStr(HtmlData,"Almanac for ")
		w(2) = Trim(Mid(HtmlData,tt+12,32))
		w(3) = Trim(NextHTMLValue(1,"Sunrise:","Sunset:",HtmlData))
		w(4) = Trim(NextHTMLValue(1,"Sunset:","Moonrise:",HtmlData))
		w(5) = Trim(NextHTMLValue(1,"Moonrise:","Moonset:",HtmlData))
		w(6) = Trim(NextHTMLValue(1,"Moonset:","Current",HtmlData))
		'------- Get Yesterday's Data Values -------------------------------------------
		w(10) = Trim(NextHTMLValue(1,"Max Temp.","Min Temp.",HtmlData))
		if not Metric then w(10) = Round(((1.8*left(w(10),len(w(10))-2))+32),0) & "F"
		w(11) = Trim(NextHTMLValue(1,"Min Temp.","Precip. Total",HtmlData))
		if not Metric then w(11) = Round(((1.8*left(w(11),len(w(11))-2))+32),0) & "F"
		w(12) = Trim(NextHTMLValue(1,"Precip. Total","Today",HtmlData))
		if not Metric then w(12) = Round((.03937*left(w(12),len(w(12))-2)),2) & "in"
		'------- Set Dummy Normal Data Values ------------------------------------------
			w(7) = "N/A": w(8) = "N/A": w(9) = "N/A"
		'------- Get the Data for the next five forecast periods -----------------------
		HtmlData = ""
		Set Http = CreateObject("Microsoft.XMLhttp")
		Http.Open "GET",GETURL & GETFOR & GETCITY & "&random=" & rnd, False
		Http.Send
		HtmlData = BinToText(Http.ResponseBody, Len(Http.ResponseBody))
		Set Http = Nothing
		HtmlData = Clean(HtmlData,"<strong>", "</strong>")
		'------- Incredibly grungy code follows ----------------------------------------
		'wscript.echo HtmlData												' Uncomment for testing
		ptr = InStr(HtmlData,"QuickCode:")
		forecast = NextHTMLValue(ptr,")","Current",HTMLData)
		w(31) = NextHTMLValue(1,"<strong>","</strong>",forecast)
		if right(w(31),5) <> "night" then
			w(32) = "Today"
		else
			w(32) = "Tonight"
		end if
		w(37) = NextHTMLValue(0,"<strong>","</strong>",forecast): w(38) = Shorten(w(37))
		w(43) = NextHTMLValue(0,"<strong>","</strong>",forecast): w(44) = Shorten(w(43))
		w(49) = NextHTMLValue(0,"<strong>","</strong>",forecast): w(50) = Shorten(w(49))
		w(55) = NextHTMLValue(0,"<strong>","</strong>",forecast): w(56) = Shorten(w(55))
		w(30) = NextHTMLValue(1,"/icons3/",".gif",forecast)
		If w(30) = "N/A" then w(30) = "29" else w(30) = right("00" & w(30), 2)
		w(30) = WEATHERCANDIRECTORY & w(30) & ".png"
		w(36) = NextHTMLValue(0,"/icons3/",".gif",forecast)
		If w(36) = "N/A" then w(36) = "29" else w(36) = right("00" & w(36), 2)
		w(36) = WEATHERCANDIRECTORY & w(36) & ".png"
		w(42) = NextHTMLValue(0,"/icons3/",".gif",forecast)
		If w(42) = "N/A" then w(42) = "29" else w(42) = right("00" & w(42), 2)
		w(42) = WEATHERCANDIRECTORY & w(42) & ".png"
		w(48) = NextHTMLValue(0,"/icons3/",".gif",forecast)
		If w(48) = "N/A" then w(48) = "29" else w(48) = right("00" & w(48), 2)
		w(48) = WEATHERCANDIRECTORY & w(48) & ".png"
		w(54) = NextHTMLValue(0,"/icons3/",".gif",forecast)
		If w(54) = "N/A" then w(54) = "29" else w(54) = right("00" & w(54), 2)
		w(54) = WEATHERCANDIRECTORY & w(54) & ".png"
		w(34) = NextHTMLValue(1,""">","<",HtmlData)
		w(40) = NextHTMLValue(0,""">","<",HtmlData)
		w(46) = NextHTMLValue(0,""">","<",HtmlData)
		w(52) = NextHTMLValue(0,""">","<",HtmlData)
		w(58) = NextHTMLValue(0,""">","<",HtmlData)
		W(33) = HighLow(w(34))
		W(39) = HighLow(w(40))
		W(45) = HighLow(w(46))
		W(51) = HighLow(w(52))
		W(57) = HighLow(w(58))
		w(34) = WordWrap(w(34),WRAPFORECASTSHORT)
		w(40) = WordWrap(w(40),WRAPFORECASTSHORT)
		w(46) = WordWrap(w(46),WRAPFORECASTSHORT)
		w(52) = WordWrap(w(52),WRAPFORECASTSHORT)
		w(58) = WordWrap(w(58),WRAPFORECASTSHORT)
		'------- Get the Full Text Forecast --------------------------------------------
		HtmlData = ""
		Set Http = CreateObject("Microsoft.XMLhttp")
		Http.Open "GET",GETURL & GETTXT & GETCITY & "&random=" & rnd, False
		Http.Send
		HtmlData = BinToText(Http.ResponseBody, Len(Http.ResponseBody))
		Set Http = Nothing
		HtmlData = Clean(HtmlData,"<B>","</B>")
		'wscript.echo HtmlData												' Uncomment for testing
		txt = NextHTMLValue(1,")","Current",HtmlData) & "<"
		w(60) = ""
		Ptr = InStr(txt,"<B>"): Ptr = InStr(Ptr + 1,txt,"<B>")
		Do until Ptr = 0
			w(60) = w(60) & Ucase(NextHTMLValue(Ptr,"<B>","<",txt)) & "%b"
			w(60) = w(60) & SimpleWrap(NextHTMLValue(0,"/B>","<",txt),WRAPFORECASTLONG) & "%b"
			Ptr = InStr(Ptr + 1, txt,"<B>")
		Loop
		'------- Write all the collected data now --------------------------------------
		set f=fs.CreateTextFile(tp, true)
		for i = 1 to 60: f.writeline w(i): next
		f.close
	end if
	set f=nothing: set fs=nothing
End Function

'-------- Cleanup HTML page of all tags but a few needed ones to assist extraction ---
Function Clean(str,opt1,opt2)
pos_deb = InStr(1, str, "<")
hi_pos = pos_deb
Do Until pos_deb = 0
	if mid(str,pos_deb,4) = "<IMG" OR _
		mid(str,pos_deb,4) = "<img" OR _
		mid(str,pos_deb,4) = "<br>" OR _
		mid(str,pos_deb,4) = "<BR>" OR _
		mid(str,pos_deb,len(opt1)) = opt1 OR _
		mid(str,pos_deb,len(opt2)) = opt2 then
		pos_deb = InStr(pos_deb + 1, str, ">")
		pos_deb = InStr(pos_deb + 1, str, "<"): hi_pos = pos_deb
	else
 	  	pos_fin = InStr(pos_deb, str, ">" )
   	part_d = Mid(str, 1, pos_deb - 1)
   	part_f = Mid(str, pos_fin + 1, Len(str) - pos_fin)
	   str = part_d & part_f
		end if
   	pos_deb = InStr(hi_pos, str, "<" )
Loop
str = Replace(str, "&nbsp;", " ")
str = Replace(str, "&deg;", chr(176))
str = Replace(str, chr(13), " ")
str = Replace(str, chr(10)," ")
str = Replace(str, chr(9), " ")
str = replace(str,"<br>", " ")
str = replace(str,"<BR>", " ")
Clean = str
End Function

'-------- Fetch the next 'n' words after a specified delimiter string ----------------
Private Function GetHTMLWords(Init,LeftBound,NumWords,Data)
	If Init = 0 then
		HtmlStart = InStr(Restart,Data, LeftBound)
	Else
		HtmlStart = InStr(Init,Data, LeftBound)
	End If
	if HtmlStart = 0 then
		GetHTMLWords = "N/A"
		exit Function
	end if
	Restart = HtmlStart + 1
	HtmlStart = HtmlStart + len(LeftBound)
	While Mid(Data,Htmlstart,1) = " "
		Htmlstart = Htmlstart + 1
	Wend
	Htmlend = Htmlstart
	While NumWords > 0
		While Mid(Data,HtmlEND,1) = " "
			Htmlend = Htmlend + 1
		Wend
		Htmlend = InStr(Htmlend,Data," ")
		NumWords = NumWords - 1
	Wend
	If HtmlStart > 0 AND HtmlEnd > 0 Then
		GetHTMLWords = Trim(Mid(Data, HtmlStart, HtmlEnd - HtmlStart ))
	Else
		GetHTMLWords = "N/A"
	End If
	TArray = split(GetHTMLWords)									' Eliminate extra spaces
	GetHTMLWords = ""
	For I = 0 to UBound(TArray)
		if TArray(I) <> "" then GetHTMLWords = GetHTMLWords & Trim(TArray(I)) & " "
	Next
	GetHTMLWords = left(GetHTMLWords,len(GetHTMLWords)-1)
End Function

'-------- Fetch the next delimited string  either from after a specified start point -
'-------- or from AFTER the last located string --------------------------------------
Private Function NextHTMLValue(Init,LeftBound,RightBound,Data)
	If Init = 0 then
		HtmlStart = InStr(Restart,Data, LeftBound) + Len(LeftBound)
	Else
		HtmlStart = InStr(Init,Data, LeftBound) + Len(LeftBound)
	End If
	if Htmlstart <= len(LeftBound) then
		NextHtmlValue = "N/A"
		exit function
	end if
	Restart = HtmlStart + 1
	HtmlEnd = InStr(HtmlStart, Data, RightBound)
	If HtmlStart > 0 AND HtmlEnd > 0 Then
		NextHTMLValue = Trim(Mid(Data, HtmlStart, HtmlEnd - HtmlStart ))
	Else
		NextHTMLValue = "N/A"
	End If
End Function

'-------- Word wrap the text forcast and eliminate the Hi/Lo values (since they're ---
'-------- already extracted) ---------------------------------------------------------
Private Function WordWrap(Sent, WrapValue)
	TArray = split(Sent)
	Sent = ""
	For I = 0 to UBound(TArray)
		if TArray(I) = "Low" or TArray(I) = "High"  then
			I = I + 1
		else
			if TArray(I) <> "" then Sent = Sent & Trim(TArray(I)) & " "
		end if
	Next
	cutlength = WrapValue
	strtcut = 0
	endcut = InStr(1, Sent, " ", 1)
	Do
   	If InStr(endcut + 1, Sent, " ", 1) > cutlength + strtcut Then
		   result = result & Mid(Sent, strtcut + 1, endcut - strtcut) & "%b"
		   strtcut = endcut
	   Else
		   endcut = InStr(endcut + 1, Sent, " ", 1)
	   End If
	Loop While Not endcut = 0
	WordWrap = result & Mid(Sent, strtcut + 1, len(Sent) - strtcut)
End Function
'-------- Simple Word Wrap -----------------------------------------------------------
Private Function SimpleWrap(Sent, WrapValue)
	cutlength = WrapValue
	strtcut = 0
	endcut = InStr(1, Sent, " ", 1)
	Do
   	If InStr(endcut + 1, Sent, " ", 1) > cutlength + strtcut Then
		   result = result & Mid(Sent, strtcut + 1, endcut - strtcut) & "%b"
		   strtcut = endcut
	   Else
		   endcut = InStr(endcut + 1, Sent, " ", 1)
	   End If
	Loop While Not endcut = 0
	SimpleWrap = result & Mid(Sent, strtcut + 1, len(Sent) - strtcut)
End Function
'-------- Fiddle around to create a Hi/Lo temperature string -------------------------
Private Function HighLow(Txt)
	High = "": Low = ""
	p = Instr(Txt,"High")
	if p > 0 then q= Instr(p, Txt,"")
	if p > 0  AND q > 0 AND (q - p) < 10 then
		High = trim(mid(Txt, p+4, q - p - 4))
		if not Metric then 
			High = Round(((1.8*High)+32),0) & ""
		else
			High = High & ""
		end if
	end if
	p = Instr(Txt,"Low")
	if p > 0 then q= Instr(p, Txt,"")
	if p > 0  AND q > 0 AND (q - p) < 10 then
		Low = trim(mid(Txt, p + 3, q - 3 - p))
		if not Metric then 
			Low = Round(((1.8*Low)+32),0) & ""
		else
			Low = Low & ""
		end if
	end if
	HighLow = High
	if HighLow <> "" then
		if Low <> "" then HighLow = HighLow & "/" & Low
	else
		HighLow = Low
	end if
End Function

'-------- Create a 'Short' day name --------------------------------------------------
Private Function Shorten(Txt)
	if right(Txt,5) = "night" then
		Shorten = "Tonight"
	else
		Shorten = left(Txt,3)
	end if
End Function

'-------- Convert Web data to Normal Text --------------------------------------------
Private Function BinToText(varBinData, intDataSizeInBytes) 
Dim objRs 
Const adFldLong = &H00000080 
Const adVarChar = 200 
	Set objRS = CreateObject("ADODB.Recordset") 
	objRS.Fields.Append "txt", adVarChar, intDataSizeInBytes, adFldLong 
	objRS.Open 
	objRS.AddNew 
	objRS.Fields("txt").AppendChunk varBinData 
	BinToText = objRS("txt").Value 
	objRS.Close 
	Set objRS = Nothing 
End Function 

