const SAMURIZE_DIRECTORY = "C:\Program Files\Samurize" ' Change the path if it is different than yours.
const HEMISPHERE = "north"


Function moonGet(dDate)

  On Error Resume Next
  Dim copy

  copy = copyImage("\images\moon\" & HEMISPHERE & "ernmoon" & moonPhase(dDate) & ".png", "moon" & dDate & ".png")

End Function


Function moonPhase(dDate)
    
    moonPhase = Int(moonAge(dDate) * (40 / 29.53058867))
    
End Function


Function moonAge(dDate)

    Dim BaseDate
    
    BaseDate = CDate("18 Nov 1998 9:36:00 pm")
    
    moonAge = remainder(((Now + dDate) - BaseDate), 29.53058867)

End Function


Function remainder(Number, DivideBy)

    If Number = 0 Then
        remainder = 0
    Else
        remainder = Number - DivideBy * Int(Number / DivideBy)
    End If
    
End Function


Function moonGetAge(dDate)

  Dim Age, AgeDay, AgeHour
  
  Age = moonAge(dDate)
  
  AgeHour = Round((Age - Int(Age)) * 24)
  
  If Int(Age) = 1 Then
    moonGetAge = "1 day, "
  Else
    moonGetAge = Int(Age) & " days, "
  End If
  
  If AgeHour = 1 Then
    moonGetAge = moonGetAge & "1 hour"
  Else
    moonGetAge = moonGetAge & AgeHour & " hours"
  End If
  
End Function


Function moonGetNextFull(dDate)

  Dim Age, AgeDay, AgeHour
  
  Age = moonAge(dDate)
  
  If Age > (29.53058867 / 2) Then
    
    moonGetNextFull = CDate(Now + (29.53058867 / 2) - Age + 29.53058867)
    
  Else
    
    moonGetNextFull = CDate(Now + (29.53058867 / 2) - Age)
  
  End If

End Function


Function moonGetNextNew(dDate)

  Dim Age, AgeDay, AgeHour
  
  Age = moonAge(dDate)
    
  moonGetNextNew = CDate(Now + 29.53058867 - Age)

End Function


Function moonGetVisible(dDate)

  Dim Age, AgeDay, AgeHour
  
  Age = moonAge(dDate)
    
  moonGetVisible = 100 - (Abs((29.53058867 / 2) - Age) / (29.53058867 / 2) * 100)

End Function


Function moonGetIcons(Num)

  Dim i
  
  For i = 0 To (Num - 1)
    moonGet(i)
  Next
  
End Function


Function moonGetDayDate(Num)
  
  moonGetDayDate = Day(CDate(Now + Num)) & "/" & Month(CDate(Now + Num))
  
End Function


Function moonGetQuarter(Num)
  
  Dim Phase
  
  Phase = moonPhase(Num)
  
  If (Phase >= 0) AND (Phase <0.51) Then
    moonGetQuarter = "NEW"
  End If
  
  If (Phase >= 39.5) AND (Phase <=40) Then
    moonGetQuarter = "NEW"
  End If
  
  If (Phase >= 9.5) AND (Phase <=10.5) Then
    moonGetQuarter = "1/2"
  End If
  
  If (Phase >= 19.5) AND (Phase <=20.5) Then
    moonGetQuarter = "FULL"
  End If
  
  If (Phase >= 29.5) AND (Phase <=30.5) Then
    moonGetQuarter = "1/2"
  End If
  
End Function


Function copyImage(imageName, tempImageName)

  Dim fso
  
  copyImage = FALSE
  
  Set fso = CreateObject("Scripting.FileSystemObject")
  
  If fso.FileExists(SAMURIZE_DIRECTORY & "\Skins\Samoonrize" & imageName) Then
    fso.CopyFile SAMURIZE_DIRECTORY & "\Skins\Samoonrize" & imageName, SAMURIZE_DIRECTORY & "\Skins\Samoonrize\temp\" & tempImageName, TRUE
    copyImage = TRUE
  End If
  
  Set fso = Nothing
  
End Function
