/*
*	AmericaTV Script v.920b by norxh
*
*	Copying:
*	Everything in this script is my own work. If you decide to use some code snippets from this script
*	or modify it to suit another project, that is fine with me. Just let me know about it and give me
*	credit where it is due.
*
*
*	@@ SCRIPT BEGINS HERE @@
*	DO NOT MODIFY BELOW UNLESS YOU KNOW WHAT YOUR DOING
*
*	user variables
*/
var user;
var pass;
var reset;
var maxPostfetch;
var fetchStep;
var truncateLengthCurrent;
var truncateLengthNext;
var showChannelNumber;
var showEpisode;
var episodeLocation;

/*
*	global variables		
*/
var baseKey = 'HKEY_CURRENT_USER\\Software\\Serious Samurize\\AmericaTV\\';
var maxOldData = 25;
var baseFile;
var myDataSource = new dataSource();
var myChannels = new channelQueue();
var fileSystem;
var shell;
var dataHighest;
var dataFile;
var dataFileStream;
var channelList;
var bOutput = '';
var bLowestCurrentLine;

/*
*	*samurizeMain function
*		This is the main entry point for Samurize. The entire script is inside the try so errors can be sent to the meter.
*/

function samurizeMain() {
	try {
		//attempt to get access to essential system functions: filesystem and registry
		try {
			fileSystem = new ActiveXObject('Scripting.FileSystemObject');
			shell = new ActiveXObject('WScript.Shell');
		} catch(e) {
			throw 'Couldn\'t load file/registry access. It may be blocked by antivirus software.';
		}
		//get ready to run script. if the script couldnt prepare or is instructed to reset, initialize. if it still can't prepare, die.
		bOutput += 'Called at: ' + (new Date()).toLocaleString() + '\n';
		if (reset || !prepare()) {
			initialize();
			if (!prepare()) throw 'There was a problem initializing the script. Check registry/file access permissions.';
		}
		//this will see if there is adequate stored data to run. if there is not, it will fetch data up to past now+maxPostfetch. 
		//finally it will call the createMeters function.
		checkData();
	} catch(e) {
		if (e instanceof Error) {
			bOutput += 'Unhandled Error: (' + (e.number>>16 & 0x7FF) + '/' + (e.number & 0xFFFF) + ') ' + e.description;
		} else {
			bOutput += 'Handled Error: ' + e;	
		}
	} finally {
		return bOutput;	
	}
}

/*
*	*getBaseFile function
*		Get user base file
*/

function getBaseFile() {
	var r;
	if ((r = shell.ExpandEnvironmentStrings('%APPDATA%')) == '%APPDATA%') {
		throw "Could not get your Application Data directory";
	}
	return r;
}

/*
*	*prepare function
*		Prepare some variables
*		Returns true if they load properly else false.
*/
function prepare() {
	try {
		user = shell.RegRead(baseKey + 'user');
		pass = shell.RegRead(baseKey + 'pass');
		maxPostfetch = shell.RegRead(baseKey + 'maxPostfetch');
		fetchStep = shell.RegRead(baseKey + 'fetchStep');
		truncateLengthCurrent = shell.RegRead(baseKey + 'truncateLengthCurrent');
		truncateLengthNext = shell.RegRead(baseKey + 'truncateLengthNext');
		showChannelNumber = shell.RegRead(baseKey + 'showChannelNumber');
		showEpisode = shell.RegRead(baseKey + 'showEpisode');
		episodeLocation = shell.RegRead(baseKey + 'episodeLocation');
	} catch(e) {
		if (checkError(e, 7, 2)) {
			throw 'Settings not found. Run the configuration application.';
		}
		throw 'Error reading registry.';
	}
	
	try {
		if (channelList = shell.RegRead(baseKey + 'channelList')) {
			channelList = channelList.split('\t');
		}
		dataHighest = shell.RegRead(baseKey + 'dataHighest') * 1000;
	} catch(e) {
		if (checkError(e, 7, 2)) return false;
		throw 'Error reading registry.';
	}
	
	try {
		baseFile = getBaseFile() + '\\AmericaTV\\';
		dataFile = fileSystem.GetFile(baseFile + 'AmericaTV.data');
	} catch(e) {
		if (checkError(e, 10, 53)) throw 'Found your registry data, but couldn\'t find your data file. It may be moved/deleted. Try resetting the script. (see the readme)';
		else throw 'Couldn\'t read the data file. (' + e.description +')';
	}
	bOutput += 'Prepared for execution succesfully.\n';
	return true;
}

/*
*	*initializeChannels function
*		Runs the first time, to store channel list
*/

function initializeChannelList(xtvdNode) {
	var bChannelList = '';
	var bMap;
	var bStation;
	var bStationId;
	var bNamedNodeMap;
	
	var stations = xtvdNode.selectNodes('stations/station');
	var maps = xtvdNode.selectNodes('lineups/lineup/map');
	
	while (bMap = maps.nextNode()) {
		bNamedNodeMap = bMap.attributes;
		bStationId = bNamedNodeMap.getNamedItem('station').value;
		bChannelList += bStationId + '\b' + bNamedNodeMap.getNamedItem('channel').value + '\b';
		
		bStation = xtvdNode.selectSingleNode('stations/station[@id = "' + bStationId + '"]/callSign');
		bChannelList += bStation.text + '\t'
	}
	
	if (!bChannelList) throw 'Error extracting channel lineup.';
	
	bChannelList = bChannelList.slice(0, -1);
	
	try {
		shell.RegWrite(baseKey + 'channelList', bChannelList, 'REG_SZ');
	} catch(e) {
		throw 'Error writing to registry.';
	}
	
	channelList = bChannelList.split('\t');
}


/*
*	*initialize function
*		Runs the first time
*/

function initialize() {
	//store channel list and get location of Samurize for creating the data file.
	try {
		baseFile = getBaseFile() + '\\AmericaTV\\';
		shell.RegWrite(baseKey + 'dataHighest', 0, 'REG_DWORD');
		shell.RegWrite(baseKey + 'channelList', '', 'REG_SZ');
		channelList = '';
	} catch(e) {
		if (checkError(e, 7, 2)) throw 'Couldn\'t find path to Samurize (General\\DirPath) in the registry.';
		else if(checkError(e, 7)) throw 'Error writing to registry.';
		throw e;
	}
	
	//create the data file.
	try {
		if (!fileSystem.FolderExists(baseFile)) {
			fileSystem.CreateFolder(baseFile);
		}
		fileSystem.CreateTextFile(baseFile + 'AmericaTV.data', true).Close();
	} catch(e) {
		throw 'Couldn\'t create the data file. (' + e.description + ')';
	}
	
	bOutput += 'Ran initialization successfully.\n';	
}

/*
*	*createMeters function
*		This function creates the text meters for importing into samurize. This function can be changed to customize output.
*
*		myChannels.channels is an array of channel objects.
*		channel objects have two properties: currentShow and nextShow which are null (if unknown) or show objects. As well as name
*		and number which are the name of the channel and the number as it appears on your tv.
*		show objects have four properties: startTime, title, and episode.
*
*   example, you have 2 channels, 12 and 47:
*
*	(channelQueue) myChannels +-- (array) channels +-- (channel) 13241 +-- (show) currentShow +-- (Date) startTime
*                             :                    |                   |                      +-- (String) title
*                             .                    |                   |                      +-- (String) episode 
*                             .                    |                   +-- (show) nextShow +-- (Date) startTime
*                                                  |                   |                   +-- (String) title
*                                                  |                   |                   +-- (String) episode
*                                                  |                   +-- (String) name
*                                                  |                   +-- (Number) number
*                                                  +-- (channel) 13525 +-- (show) currentShow +-- (Date) startTime
*                                                                      |                      +-- (String) title
*                                                                      |                      +-- (String) episode 
*                                                                      +-- (show) nextShow +-- (Date) startTime
*                                                                      |                   +-- (String) title
*                                                                      |                   +-- (String) episode     
*                                                                      +-- (String) name
*                                                                      +-- (Number) number
*
*/

function createMeters() {
	//(global) baseFile;
	//(global) fileSystem;
	//(global) myChannels;
	//(global) bOutput; 
	var currentStream;
	var progressStream;
	var nextStream;
	var episodeStream;
	var bKey;
	var bDate;
	var doEpisodeFile = showEpisode && episodeLocation;
	
	try {
		currentStream  = fileSystem.CreateTextFile(baseFile + 'AmericaTV.meter-current.txt', true);
		progressStream = fileSystem.CreateTextFile(baseFile + 'AmericaTV.meter-progress.txt', true);
		nextStream     = fileSystem.CreateTextFile(baseFile + 'AmericaTV.meter-next.txt', true);
		if (doEpisodeFile) {
			episodeStream = fileSystem.CreateTextFile(baseFile + 'AmericaTV.meter-episode.txt', true);
		}
	} catch (e) {
		throw 'Error creating text meter files. (' + e.description + ')';	
	}
	
	bDate = new Date();
	
	with (myChannels) {
		for (bKey in channels) {
			if (channels[bKey].currentShow) {
				currentStream.WriteLine((showChannelNumber ? channels[bKey].number + '%tab' : '') + '(' + meterTimeFormat(channels[bKey].currentShow.startTime) + ') ' + meterTruncate(channels[bKey].currentShow.title + (showEpisode && !episodeLocation && channels[bKey].currentShow.episode ? ': ' + channels[bKey].currentShow.episode : ''), truncateLengthCurrent));
				progressStream.WriteLine(Math.round(((bDate.valueOf() - channels[bKey].currentShow.startTime.valueOf()) / channels[bKey].currentShow.duration) * 100));
				if (doEpisodeFile) episodeStream.WriteLine(channels[bKey].currentShow.episode);
			} else {
				progressStream.WriteLine(0);
				currentStream.WriteLine((showChannelNumber ? channels[bKey].number + '%tab': '') + '(--:-- --) Unknown');
				if (doEpisodeFile) episodeStream.WriteLine();
			}

			if (channels[bKey].nextShow) {
				nextStream.WriteLine('(' + meterTimeFormat(channels[bKey].nextShow.startTime) + ') ' + meterTruncate(channels[bKey].nextShow.title, truncateLengthNext));
			} else { 
				nextStream.WriteLine('(--:-- --) Unknown');
			}
		}
	}
	
	currentStream.Close();
	progressStream.Close();
	nextStream.Close();
	bOutput += 'CreateMeters completed successfully.\n';
}

function meterTimeFormat(time) {
	var hours = time.getHours();
	var mins  = time.getMinutes();
	var meridiem = hours > 11 ? ' PM':' AM'; 
	hours = hours > 12 ? hours - 12:hours;
	if (!hours) hours = 12;
	return (hours < 10 ? '0' + hours:hours) + ':' + (mins < 10 ? '0' + mins:mins) + meridiem; 
}

function meterTruncate(data, length) {
	return data.length > length ? data.substr(0, length) + '...':data;
}

/*
*	*checkData function
*		This will prepare the for and call the createMeters function.
*/

function checkData() {
	bOutput += 'Beginning data examination.\n';
	//setup the channel queue which will hold all the data needed for the display.
	var bDuration;

	//data file: start\bduration\bchannelId\btitle\tepisode
	//start reading the datafile and get current shows
	var bDate = new Date();
	var bDate2 = new Date();
	var bMaxPostfetch;
	var bLine;
	dataFileStream = dataFile.OpenAsTextStream(1);
	
	//if newest data is older than current time we need to update
	if (dataHighest < bDate.valueOf()) {
		if (fetchStep < 6) bDuration = fetchStep;
		else bDuration = 6;
		bDate2.setHours(bDate2.getHours());
		bLowestCurrentLine = 0;
		updateData(bDate2, bDuration);
	}
	
	myChannels.populate();
	
	while(!dataFileStream.AtEndOfStream) {
		bLine = dataFileStream.ReadLine().split('\b');
		if (bLine[0] > bDate.valueOf()) break;
		myChannels.updateCurrentShow(bLine[2], new show(new Date(parseInt(bLine[0])), parseInt(bLine[1]), bLine[3], bLine[4]), dataFileStream.Line - 1);
	}
	//continue reading past current time to get next shows
	if (bLine[0] > bDate.valueOf())
		myChannels.updateNextShow(bLine[2], new show(new Date(parseInt(bLine[0])), bLine[1], bLine[3], bLine[4]));
	bDate2 = new Date();
	bDate2.setHours(bDate2.getHours() + maxPostfetch);
	bMaxPostfetch = bDate2.valueOf();
	while(!myChannels.haveAllNextShows()) {
		while(!dataFileStream.AtEndOfStream && !myChannels.haveAllNextShows()) {
			bLine = dataFileStream.ReadLine().split('\b');
			if (!myChannels.haveNextShow(bLine[2])) myChannels.updateNextShow(bLine[2], new show(new Date(parseInt(bLine[0])), bLine[1], bLine[3], bLine[4]));
		}
		if (myChannels.haveAllNextShows()) break;
		bDate2 = new Date(dataHighest);
		if (bLowestCurrentLine == null)
			bLowestCurrentLine = myChannels.getLowestCurrentLine();
		if (dataHighest < bMaxPostfetch) updateData(bDate2, fetchStep);
		else break;
	}
	bOutput += 'Finished data examination.\nCalling createMeters functions.\n';	
	createMeters();
}

/*
*	*updateData helper functions
*
*/

function tSortBuffer(x,y) {
	this.time = x;
	this.programId = y;
}
tSortBuffer.prototype.toString = function () {
	return this.time;
}

function parseXmlDateTime(input) {
	return Date.UTC(input.substr(0,4),input.substr(5,2)-1,input.substr(8,2),
		input.substr(11,2),input.substr(14,2),input.substr(17,2));
}

function parseXmlDuration(input) {
	return input.substr(2,2) * 3600000 + input.substr(5,2) * 60000;
}

/*
*	*updateData function
*		Append new data to the data file.
*		Uses global var bLowestCurrentLine to determine how to handle file. Possible values:
*			-1		Append. Var is always set to this after first call to func.
*			0		Overwrite
*			<maxOld	Append
*			>maxOld	Remove old data and append
*			TODO: catch some exceptions while building the data file, e.g. new chans not synced with reg data
*/

function updateData(beginTime, duration) {
	var i;
	var xtvdNode;
	var bCurrentTime;
	var bEndTime;
	var bOldLine = 1;

	beginTime.setSeconds(0);
	beginTime.setMilliseconds(0);
	beginTime.setMinutes(0);
	bEndTime = new Date(beginTime.valueOf());
	bEndTime.setHours(bEndTime.getHours() + duration);

	bOutput += 'Beginning data update: ' + beginTime.getFullYear() + '-' + (beginTime.getMonth() + 1) + '-' +  beginTime.getDate() + ' Hour: ' + beginTime.getHours() + ' Duration: ' + duration + '\n';
	//prepare the data file
	if (bLowestCurrentLine == 0) {
		dataFileStream.Close();
		dataFileStream = dataFile.OpenAsTextStream(2);	
	} else if (bLowestCurrentLine <= maxOldData) {
		dataFileStream.Close();
		dataFileStream = dataFile.OpenAsTextStream(8);
		bOldLine = dataFileStream.Line;
	} else {
		//remove old data
		dataFileStream.Close();
		dataFileStream = dataFile.OpenAsTextStream(1);	
		var tempDataFileStream = fileSystem.CreateTextFile(baseFile + 'AmericaTV.data.temp', true);
		bLowestCurrentLine--;
		for (i = 0; i < bLowestCurrentLine; i++)
			dataFileStream.SkipLine();
		while (!dataFileStream.AtEndOfStream)
			tempDataFileStream.WriteLine(dataFileStream.ReadLine());
		dataFileStream.Close();
		tempDataFileStream.Close();
		dataFile.Delete();
		dataFile = fileSystem.GetFile(baseFile + 'AmericaTV.data.temp');
		dataFile.Name = 'AmericaTV.data';
		dataFileStream = dataFile.OpenAsTextStream(8);
		bOldLine = dataFileStream.Line;
	}
	bLowestCurrentLine = -1;
	//retrieve the new data
	var soapRequest = 
		'<?xml version="1.0" encoding="UTF-8"?>' +
		'<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ns1="urn:TMSWebServices" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:SOAP-ENC="http://schemas.xmlsoap.org/soap/encoding/" SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">' +
		'	<SOAP-ENV:Body>' +
		'		<ns1:download>' +
		'			<startTime xsi:type="xsd:dateTime">' + beginTime.getUTCFullYear() + '-' + (beginTime.getUTCMonth() + 1) + '-' + beginTime.getUTCDate() + 'T' + beginTime.getUTCHours() + ':00:00Z</startTime>' +
		'			<endTime xsi:type="xsd:dateTime">' + bEndTime.getUTCFullYear() + '-' + (bEndTime.getUTCMonth() + 1) + '-' + bEndTime.getUTCDate() + 'T' + bEndTime.getUTCHours() + ':00:00Z</endTime>' +
		'		</ns1:download>' +
		'	</SOAP-ENV:Body>' +
		'</SOAP-ENV:Envelope>';
	myDataSource.writeRequest('POST', 'http://datadirect.webservices.zap2it.com/tvlistings/xtvdService', soapRequest);
	
	//invalid http response?
	if (myDataSource.getResponseCode() != 200) throw "Invalid reponse code: " + myDataSource.getResponseCode(true);
	
	//invalid xml?
	xtvdNode = myDataSource.readResponse();
	if (!xtvdNode || xtvdNode.parseError.errorCode != 0) {
	   throw "XML Failed to parse: " + (xtvdNode ? xtvdNode.parseError.reason:'');
	}
	
	//soap fault?
	//code here
	
	//get the info node	
	xtvdNode = xtvdNode.selectSingleNode("//xtvd");
	if (!channelList) initializeChannelList(xtvdNode);
	
	myChannels.populate();
	
	//store the new data
	var bNode;
	var bTime;
	var bTimeString;
	var bDate;
	var bNamedNodeMap;
	var bSortArray = new Array();
	var bWrite = new Array(5);
	
	var schedules = xtvdNode.selectNodes('schedules/schedule');
	
	//we need to store data in ascending time order. so we get all programId/times and sort them.
	while (bSchedule = schedules.nextNode()) {
		bNamedNodeMap = bSchedule.attributes;
		bSortArray.push(new tSortBuffer(bNamedNodeMap.getNamedItem('time').value, bNamedNodeMap.getNamedItem('program').value));
	}
	bSortArray = bSortArray.sort();
	
	//data file: start\bduration\bchannelId\btitle\tepisode
	//now we can assemble the data and write it to the file. using the sorted list we can call them in the correct order
	for(var i = 0; i < bSortArray.length; i++) {
		//get time and cache so we dont parse same string more than once
		if (bSortArray[i].time == bTimeString) {
			bWrite[0] = bTime;
		} else {
			bTimeString = bSortArray[i].time;
			bWrite[0] = bTime = parseXmlDateTime(bSortArray[i].time);
		}
		
		//if we are appending and this is back fill data, then skip it
		if (bOldLine != 1 && bTime < dataHighest) continue;
		
		//get the rest of the data from the tree
		bNode = xtvdNode.selectSingleNode('schedules/schedule[@program = "' + bSortArray[i].programId + '"]');
		bNamedNodeMap = bNode.attributes;
		
		bWrite[1] = parseXmlDuration(bNamedNodeMap.getNamedItem('duration').value);
		bWrite[2] = bNamedNodeMap.getNamedItem('station').value;
		//Do we know this station?
		if (!(bWrite[2] in myChannels.channels)) throw 'New channel data found. Reset the script. (see readme)';
		
		bNode = xtvdNode.selectSingleNode('programs/program[@id = "' + bSortArray[i].programId + '"]');
				
		bWrite[3] = bNode.selectSingleNode('title').text;
		
		if (bNode = bNode.selectSingleNode('subtitle')) {
			bWrite[4] = bNode.text;
		} else {
			bWrite[4] = '';
		}
		
		//add it to the data file
		dataFileStream.WriteLine(bWrite.join('\b'));
	}	
	
	//reopen file for reading, set pointer to new data with bOldLine.
	dataFileStream.Close();
	dataFileStream = dataFile.OpenAsTextStream(1);
	bOldLine--;
	for (i = 0; i < bOldLine; i++) dataFileStream.SkipLine();
	//set new datahighest in the var and registry.
	dataHighest = bEndTime.valueOf();
	try {
		shell.RegWrite(baseKey + 'dataHighest', dataHighest/1000, 'REG_DWORD');
	} catch(e) {
		throw 'Error updating highestData registry key.';
	}
	bOutput += 'Finished data update.\n';
}

/*
*	data classes
*		These are used to organize the data.
*/
	
function channelQueue() {
	this.channels = new Array();
	var lowestLineData = new Array();
	var countNext = 0;
	var populated = false;
	
	this.populate = function() {
		if (populated) return;
		var bChannel;
		for(var i = 0; i<channelList.length; i++) {
			bChannel = channelList[i].split('\b');
			this.addChannel(bChannel[0], bChannel[1], bChannel[2]);
		}
		populated = true;
	}
	
	this.addChannel = function(channelId, number, name) {
		this.channels[channelId] = new channel(number, name);
		countNext++;
	}
	
	this.updateCurrentShow = function(channelId, myShow, line) {
		lowestLineData[channelId] = line;
		this.channels[channelId].currentShow = myShow;
	}
	
	this.updateNextShow = function(channelId, myShow) {
		this.channels[channelId].nextShow = myShow;
		countNext--;
	}
	
	this.haveNextShow = function(channelId) {
		return this.channels[channelId].nextShow != null;
	}
	
	this.haveAllNextShows = function() {
		return countNext == 0;
	}
	
	this.getLowestCurrentLine = function () {
		var bLowest = Number.POSITIVE_INFINITY;
		var bKey;
		for (bKey in lowestLineData) 
			if (lowestLineData[bKey] < bLowest) bLowest = lowestLineData[bKey];
		return bLowest;
	}
}

function channel(number, name) {
	this.name = name;
	this.number = number;
	this.currentShow;
	this.nextShow;	
}

function show(startTime, duration, title, episode) {
	this.startTime = startTime;
	this.duration = duration;
	this.title = title;
	this.episode = episode;	
}

/*
*	*dataSource class
*		This is my attempt to abstract the internet connection somewhat.
*/

function dataSource() {
	//(global) user;
	//(global) pass;
	var conn = null;
		
	function connLoaded() {
		try {
			if (conn == null) conn = new ActiveXObject('Msxml2.XMLHTTP.3.0');
		} catch(e) {
			throw 'Couldn\'t load MSXML. It may not be installed.';
		}
	}
		
	this.writeRequest = function(type, reqUrl, data) {
		connLoaded();
		try {
			conn.open(type, reqUrl, false, user, pass);
			if (data != null && type == 'POST') {
				conn.send(data);
			} else conn.send();
		} catch(e) {
			throw 'There was an error sending a request on the net. (' + e.description + ')';		
		}
	}
	
	this.readResponse = function() {
		return conn.responseXML;
	}
	
	this.getResponseCode = function(withText) {
		if (withText) return conn.status + ' ' + conn.statusText;
		return conn.status;
	}
}

/*
*	*checkError function
*		This function is for easy checking of errors with ints.
*		Returns true if given facility/error code matches the error object else false.
*/

function checkError(e, facility, error) {
	if (facility != null) {
		if ((e.number>>16 & 0x7FF) != facility) return false;
	}
	if (error != null) {
		if ((e.number & 0xFFFF) != error) return false;
	}
	return true;
}

//WScript.echo(samurizeMain());